/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于芯片调节页面
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.19
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported get_brightness_msg */
/* exported mc_send_box_bright_date */
/* exported mc_bright_date_formative */
/* exported mc_get_box_bright_date */
/* exported mc_bright_str_formative */
/* exported mc_io_json_hw_box_offline_mode */
/* exported mc_io_json_hw_box_online_debug */
/* exported mc_constructor_debug_ui */


/* global $ */
/* global mc_sdk_param */
/* global mc_add_item_prefix */
/* global mc_ui_lab */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取亮度控件数据及设置控件本身是否合并数组
 * 参数:
 *     @param { Promise<Array> } arr_val 数据数组[R,G,B] 可为空
 * 返回：
 *    @return { Promise<Array> }
 *     [控件数据字串, 控件本身是否合并数组]
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.29
 *      内容 : 所有代码
 ************************************************************************************************/
function get_brightness_msg(arr_val) {
    var arr_param_name = ["MC_LANG_ALL_CHANNELS", "MC_LANG_OPTION_CLR_R", "MC_LANG_OPTION_CLR_G", "MC_LANG_OPTION_CLR_B"];
    var obj_combo_mode = {};
    var obj_sdk_param = new mc_sdk_param();
    var arr_set_val = [100, 100, 100, 100];

    if (arr_val instanceof Array) {
        // 添加所有通道
        arr_val.unshift(arr_val[0]);
        arr_set_val = arr_val;
    }

    obj_sdk_param.set_param_clear();

    for (var idx = 0; idx < arr_param_name.length; idx++) {
        var str_param_name = arr_param_name[idx];
        var str_val = arr_set_val[idx] + "";

        obj_sdk_param.set_param_value(str_param_name, str_val);
        obj_sdk_param.set_attr_val(str_param_name, "UI_TYPE", "SLIDER");
        obj_sdk_param.set_attr_val(str_param_name, "MAX_VAL", "100");
        obj_sdk_param.set_attr_val(str_param_name, "MIN_VAL", "0");
        obj_sdk_param.set_attr_val(str_param_name, "STEP", "1");
        obj_combo_mode[str_param_name] = true;
    }
    return [obj_sdk_param.get_json(), obj_combo_mode];
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    亮度信息转换为固定格式 - 发送数据转换
 * 参数:
 *     @param { Promise<Array> } str_date 亮度信息json字串
 * 返回：
 *    @return { Promise<String> }
 *     (R_BRIGHT:G_BRIGHT:B_BRIGHT)
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_bright_date_formative(str_date) {
    if ("string" !== typeof str_date || 0 === str_date.length) {
        return false;
    }
    var str_formative_date = "";
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_json(str_date);

    str_formative_date = "(" + obj_sdk_param.get_param_value("MC_LANG_OPTION_CLR_R") + ":" + obj_sdk_param.get_param_value("MC_LANG_OPTION_CLR_G") + ":" + obj_sdk_param.get_param_value("MC_LANG_OPTION_CLR_B") + ")";
    return str_formative_date;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将rabg亮度字串转换为数据数组 (R_BRIGHT:G_BRIGHT:B_BRIGHT) -> [R,G,B];
 * 参数:
 *     @param { Promise<String> } str_date rabg亮度字串
 * 返回：
 *    @return { Promise<Array> }
 *     数据数组[R,G,B]
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_bright_str_formative(str_date) {
    if ("string" !== typeof str_date || 0 === str_date.length) {
        return false;
    }
    var arr_bright_date = [];
    var arr_date = str_date.split(":");

    arr_bright_date.push(Number(arr_date[0].slice(1)));
    arr_bright_date.push(Number(arr_date[1]));
    arr_bright_date.push(Number(arr_date[2].slice(0, arr_date[2].length - 1)));
    return arr_bright_date;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取箱体亮度信息
 * 参数:
 *     @param { Promise<String> } str_order 指令
 *     @param { Promise<Function> } fun_callback 回调函数
 * 返回：
 *    null
 *    fun_callback(rabg亮度字串) - (R_BRIGHT:G_BRIGHT:B_BROGHT)
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟 李智明
 *      时间 : 2020.6.29 2020.10.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_box_bright_date(str_order, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func("HW_BOX_BRIGHT");
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_param_value("RECVCARD", str_order);
    obj_sdk_param.set_attr_val("RECVCARD", "CMD", "");
    $.post("/access_shell", obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        obj_sdk_param.set_param_clear();
        obj_sdk_param.set_json(response);

        fun_callback(obj_sdk_param.get_attr_val("RECVCARD", "CMD"));
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体亮度信息
 * 参数:
 *     @param { Promise<Object> } obj_param 参数对象
 *     @param { Promise<Function> } fun_callback 回调函数
 * 备注:
 *     参数对象
 *      obj_param = {
 *      str_recvcard : "接收卡索引", // (SEND_IDX:SEND_PORT:HUB_ID:HUB_PORT:RECV_IDX)
 *      str_bright_data:"亮度信息", //亮度信息字串 (R_BRIGHT:G_BRIGHT:B_BROGHT) 亮度百分比,取值0-100
 *      str_chip_name:"接收卡芯片名称",
 *      str_memtype:"数据类型" //(应用RAM/固化FLS)
 *      }
 * 返回：
 *    null
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_send_box_bright_date(obj_param, fun_callback) {
    if ("object" !== typeof obj_param) {
        return;
    }
    var obj_sdk_param = new mc_sdk_param();

    var str_fun_name = "HW_BOX_BRIGHT";
    var str_order = obj_param.str_recvcard;
    var str_key = "RECVCARD";

    if ("0" === parent.g_str_curr_send_location) {
        str_fun_name = "HW_SENDCARD_BRIGHT";
        str_order = str_order.slice(1, -1).split(":")[0];
        str_key = "CARD";
        obj_param.str_chip_name = "";
        // str_order = "(" + str_order + ")";
    }

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func(str_fun_name);
    obj_sdk_param.set_cmd("SET_PARAM");
    obj_sdk_param.set_param_value(str_key, str_order);
    obj_sdk_param.set_attr_val(str_key, "CMD", obj_param.str_bright_data);
    if (obj_param.str_chip_name) {
        obj_sdk_param.set_attr_val(str_key, "CHIPNAME", obj_param.str_chip_name);
    }
    obj_sdk_param.set_attr_val(str_key, "MEMTYPE", obj_param.str_memtype);

    $.post("/access_shell", obj_sdk_param.get_json(), function (_response, status) {
        if ("success" !== status) {
            return;
        }
        obj_sdk_param.set_param_clear();
        obj_sdk_param.set_json(_response);
        var str_error = obj_sdk_param.get_param_value("ERROR_CODE");

        fun_callback(str_error);
    }, "text");
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读写箱体断线模式
 * 参数:
 *    @param { Promise<String> } io 1 === 写 || 其他 === 读
 *    @param { Promise<String> } params 读写构造json串需要传递的参数; 该数据格式为 obj_format_debug_data 实例
 *    @param { Promise<object> } obj_mass_mirror 群发/镜像
 *    @param { Promise<String> } callback
 * 返回:
 *    NA
 * 例子:
 *    var param = {
 * }
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-08-28
 *       内容 : 所有代码
************************************************************************************************/
function mc_io_json_hw_box_offline_mode(io, params, obj_mass_mirror, callback) {
    var obj_param = new mc_sdk_param();
    var str_param_name = "RECVCARD";

    obj_param.set_param_clear();
    obj_param.set_cmd("GET_PARAM");
    obj_param.set_func("HW_BOX_OFFLINE_MODE");

    if (1 === io) {
        obj_param.set_cmd("SET_PARAM");
    }

    obj_param.set_param_value(str_param_name, params.recvcard);
    obj_param.set_attr_val(str_param_name, "MODE", params.mode);
    obj_param.set_attr_val(str_param_name, "VALID_LIST", params.valid_list);
    obj_param.set_attr_val(str_param_name, "CHIPNAME", params.chip);
    obj_param.set_attr_val(str_param_name, "MEMTYPE", params.memtype);

    // 添加工作模式参数
    if (1 === io) {
        var str_workmode = "0";   // eslint-disable-line

        // RAM
        if ("RAM" === params.memtype) {
            if (obj_mass_mirror.b_chip_mass) {
                str_workmode = "1";
            }
        }
        // FLASH
        if ("FLASH" === params.memtype) {
            if (obj_mass_mirror.b_chip_mass) {
                str_workmode = "1";
            }
            if (obj_mass_mirror.b_chip_mirror) {
                str_workmode = "2";
            }
            if (obj_mass_mirror.b_chip_mass && obj_mass_mirror.b_chip_mirror) {
                str_workmode = "3";
            }
        }
        // obj_param.set_attr_val(str_param_name, "WORKMODE", str_workmode);
    }

    var str = obj_param.get_json();

    // console.log("[断线模式读写]",io,JSON.parse(str));

    $.post("/access_shell", str, function (res, status) {
        if ("success" !== status || "function" !== typeof callback) {
            return;
        }

        obj_param.set_param_clear();
        obj_param.set_json(res);
        var str_err = obj_param.get_param_value("ERROR_CODE");
        var str_recvcard_err = obj_param.get_attr_val(str_param_name, "ERROR_CODE");
        var error_code = "0x00000000";

        if ((str_err && error_code !== str_err) || (str_recvcard_err && error_code !== str_recvcard_err)) {
            callback(true, res);
            return;
        }

        callback(false, res);
    }, "text");
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读写箱体在线调试
 * 参数:
 *    @param { Promise<String> } io 1 === 写 || 其他 === 读
 *    @param { Promise<String> } params 读写构造json串需要传递的参数; 该数据格式为 obj_format_debug_data 实例
 *    @param { Promise<String> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-08-29
 *       内容 : 所有代码
************************************************************************************************/
function mc_io_json_hw_box_online_debug(io, params, callback) {
    var obj_param = new mc_sdk_param();
    var str_param_name = "RECVCARD";

    obj_param.set_param_clear();
    obj_param.set_cmd("GET_PARAM");
    obj_param.set_func("HW_BOX_ONLINE_DEBUG");

    if (1 === io) {
        obj_param.set_cmd("SET_PARAM");
    }

    obj_param.set_param_value(str_param_name, params.recvcard);
    obj_param.set_attr_val(str_param_name, "MODE", params.mode);
    obj_param.set_attr_val(str_param_name, "VALID_LIST", params.valid_list);
    obj_param.set_attr_val(str_param_name, "CHIPNAME", params.chip);

    var str = obj_param.get_json();

    // console.log("[在线调试读写]",io,JSON.parse(str));

    $.post("/access_shell", str, function (res, status) {
        if ("success" !== status || "function" !== typeof callback) {
            return;
        }

        obj_param.set_param_clear();
        obj_param.set_json(res);
        var str_err = obj_param.get_param_value("ERROR_CODE");
        var str_recvcard_err = obj_param.get_attr_val(str_param_name, "ERROR_CODE");
        var error_code = "0x00000000";

        if ((str_err && error_code !== str_err) || (str_recvcard_err && error_code !== str_recvcard_err)) {
            callback(true, res);
            return;
        }

        callback(false, res);
    }, "text");
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取构造调试块的json字串
 * 参数:
 *    @param { Promise<String> } str_json 读取卡的返回的json字串
 *    @param { Promise<String> } str_param_name 构造控件组的json字串name_id
 *    @param { Promise<String> } obj_item 控件的对象
 *    @param { Promise<String> } obj_lang 语言表；可为空；若为空则返回的数据不带翻译
 * 返回:
 *    @returns { Promise<String> } 返回 str_html === 构造模块的html && mode_val === 字串的mode值
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-08-28
 *       内容 : 所有代码
************************************************************************************************/
function mc_constructor_debug_ui(str_json, str_param_name, obj_item, obj_lang) {
    if ("string" !== typeof str_json || "string" !== typeof str_param_name) {
        return false;
    }

    if ("[object Object]" !== Object.prototype.toString.call(obj_item)) {
        return false;
    }


    // get
    var obj_param_res = new mc_sdk_param();
    var str_param_name_res = "RECVCARD";

    obj_param_res.set_json(str_json);

    var str_valid_list = obj_param_res.get_attr_val(str_param_name_res, "LIST");
    var defalut_val = obj_param_res.get_attr_val(str_param_name_res, "MODE");

    if (!str_valid_list) {
        return false;
    }

    // set
    var obj_lab = new mc_ui_lab();
    var lab_width = "72px";

    obj_lab.set_add_css("item_gp_name");
    obj_lab.set_add_css("lable_margin_left");
    obj_lab.set_style_width(lab_width);
    obj_lab.set_val(str_param_name);
    obj_lab.set_title(str_param_name);

    if ("[object Object]" === Object.prototype.toString.call(obj_lang)) {
        if (Object.prototype.hasOwnProperty.call(obj_lang, str_param_name)) {
            obj_lab.set_val(obj_lang[str_param_name]);
            obj_lab.set_title(obj_lang[str_param_name]);
        }
    }

    obj_item.set_add_css("mc_igp_item_container");
    obj_item.set_style_width("calc(91% - " + lab_width + ")");
    obj_item.set_arr(mc_add_item_prefix(str_valid_list, str_param_name + "_", obj_lang).split(","));

    // set return mode val
    var re_mode_val = "";

    if (str_valid_list) {
        var arr_list = str_valid_list.split(",");

        // if (arr_list.includes(defalut_val)) {
        // ie compatible
        if (-1 !== JSON.stringify(arr_list).indexOf(JSON.stringify(defalut_val))) {
            re_mode_val = defalut_val;
            obj_item.set_val(re_mode_val);
        }
    }

    // return html & MODE val
    return {
        mode_val: re_mode_val,
        str_html: obj_lab.get_html_txt() + obj_item.get_html_txt()
    };
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取发送卡端口 获取发送卡每个端口的备份状态
 * 参数:
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_send_p_backup_status(fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }
    var arr_s_p = [];

    // 请求对象
    var obj_req_s_p = new mc_sdk_param();

    obj_req_s_p.set_param_clear();
    obj_req_s_p.set_func("HW_SENDCARD_CONNECT");
    obj_req_s_p.set_cmd("GET_PARAM");

    $.post("/access_shell", obj_req_s_p.get_json(), function (result, status) {
        var obj_res_s_p = new mc_sdk_param();

        obj_res_s_p.set_param_clear();
        obj_res_s_p.set_json(result);

        var ui_param_cnt = obj_res_s_p.get_param_cnt();

        for (var idx = 0; idx < ui_param_cnt; idx++) {
            var str_param_name = obj_res_s_p.get_param_name(idx);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            var str_param_val = obj_res_s_p.get_param_value(str_param_name);
            var str_cnt = str_param_val.split(":")[1];

            arr_s_p.push(str_cnt);
        }

        var str_s_id = mc_get_top_data("g_obj_sendcard_data").get_current_sendcard_param() + "";
        var ui_s_p_cnt = Number(arr_s_p[0]);
        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("GET_PARAM");
        obj_req.set_func("HW_SENDCARD_OUTPORT_BACKUP");

        for (var id = 0; id < ui_s_p_cnt; id++) {
            var str_data = "(" + str_s_id + ":" + id + ")";

            obj_req.set_param_value(str_data, "");
        }

        $.post("/access_shell", obj_req.get_json(), function (backup_result, status) {
            var arr_backup_status = [];
            var obj_res = new mc_sdk_param();

            obj_res.set_param_clear();
            obj_res.set_json(backup_result);
            var ui_par_cnt = obj_res.get_param_cnt();

            for (var key = 0; key < ui_par_cnt; key++) {
                var str_par_name = obj_res.get_param_name(key);

                if ("ERROR_CODE" === str_par_name) {
                    continue;
                }
                var str_par_val = obj_res.get_param_value(str_par_name);
                var str_cnt_backup = str_par_val;

                arr_backup_status.push(str_cnt_backup);
            }


            fun_callback(arr_backup_status);
            return;
        });
        return;
    });
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读写HUB输出口使能
 * 参数:
 *    @param {Promise<string>} str_order     命令
 *    @param {Promise<string>} str_type     下发方式
 *    @param {Promise<Array>} arr_backup_status     当前发送卡下的输出口的备份
 *    @param {Promise<function>} fn_callback     回调
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.05
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_send_backup_port(str_order, str_type, arr_backup_status, fn_callback) {
    // 指令去前三个
    var arr_order = str_order.slice(1, -1).split(":");

    var str_s_id = arr_order[0];

    // 默认发第一张卡
    if ("-1" === str_s_id || 1 === str_s_id) {
        str_s_id = "0";
    }

    // var str_s_p_id = arr_order[1];
    // var str_h_id = arr_order[2];
    var arr_send_order = [];

    // 先获取发送卡端口
    // 获取发送卡下的端口所有可能存在的hub卡 不区分界面数据
    var ui_s_p_len = arr_backup_status.length;
    // 获取此发送卡下所有端口的hub

    for (var idx = 0; idx < ui_s_p_len; idx++) {
        var str_send_order = str_s_id + ":" + idx;

        arr_send_order.push(str_send_order);
    }
    // 获取hub卡端口数量
    mc_get_hub_p_cnt(arr_send_order, function (obj_data) {
        // 下发备份口
        mc_set_each_backup_port_send(arr_order, str_type, obj_data, arr_backup_status, function (data) {
            fn_callback(data);
            return;
        });
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取hub卡端口数量
 * 参数:
 *    @param {Promise<string>} arr_order     界面所选的指令
 *    @param {Promise<function>} fn_callback     回调

 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.05
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_hub_p_cnt(arr_order, fn_callback) {
    // 请求对象
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("HW_HUBCARD_CONNECT");
    var ui_order_cnt = arr_order.length;

    for (var idx = 0; idx < ui_order_cnt; idx++) {
        obj_req.set_param_value((idx + ""), arr_order[idx]);
    }

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        var obj_res = new mc_sdk_param();

        obj_res.set_param_clear();
        obj_res.set_json(result);

        var ui_param_cnt = obj_res.get_param_cnt();
        var obj_h_p_cnt = {};


        for (var id = 0; id < ui_param_cnt; id++) {
            var str_param_name = obj_res.get_param_name(id);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            var str_param_val = obj_res.get_param_value(str_param_name);
            var ui_attr_cnt = obj_res.get_attr_cnt(str_param_name);

            for (let id_attr = 0; id_attr < ui_attr_cnt; id_attr++) {
                var str_attr_name = "STATUS";
                var str_attr_val = obj_res.get_attr_val(str_param_name, str_attr_name);
                // 防止hub串联
                var arr_series_hub = str_attr_val.split(",");
                var ui_serier_len = arr_series_hub.length;
                var arr_series_cnt = [];
                var arr_series_hub_name = [];

                for (var idx_series = 0; idx_series < ui_serier_len; idx_series++) {
                    var str_each_series_hub = arr_series_hub[idx_series];
                    var str_name = str_each_series_hub.split(":")[0];
                    var str_cnt = str_each_series_hub.split(":")[1];

                    arr_series_hub_name.push(str_name);
                    arr_series_cnt.push(str_cnt);
                }
                obj_h_p_cnt[str_param_val] = JSON.parse(JSON.stringify({
                    "cnt": "",
                    "name": ""
                }));
                obj_h_p_cnt[str_param_val].cnt = arr_series_cnt;
                obj_h_p_cnt[str_param_val].name = arr_series_hub_name;
            }
        }
        fn_callback(obj_h_p_cnt);
        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发备份口参数
 * 参数:
 *    @param {Promise<string>} arr_order     cmd方式
 *    @param {Promise<string>} str_type     下发方式
 *    @param {Promise<object>} obj_data      port数量 key: 指令  val : 数组 [] 存在多个时 表示串联
 *    @param {Promise<Array>} arr_backup_status       当前发送卡输出端口的备份状态
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.04
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_each_backup_port_send(arr_order, str_type, obj_data, arr_backup_status, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback(false);
        return;
    }


    // 筛选界面数据 和硬件实际数据
    var arr_result = mc_handle_page_hw_data(arr_order, obj_data);

    // var arr_hub_name = arr_result[2];

    // if (0 === arr_result[0].length) {
    //     fun_callback(false);
    //     return;
    // }

    // 进一步筛选
    var arr_req = mc_backup_port_filter_data(arr_order, str_type, arr_result, arr_backup_status);
    var str_req = arr_req[0];
    var arr_data = arr_req[1];

    if (!str_req) {
        fun_callback(false);
        return;
    }

    $.post("/access_shell", str_req, function (result, status) {
        fun_callback(arr_data);
        return;
    });
}

// 处理硬件和界面显示
function mc_handle_page_hw_data(arr_order, obj_data) {
    // 界面数据
    var str_s_id = arr_order[0];
    var str_s_p_id = arr_order[1];
    var str_h_id = arr_order[2];

    // var ui_page_s = Number(str_s_id);
    var ui_page_h = Number(str_h_id);

    var str_s_p_page = str_s_id + ":" + str_s_p_id;

    // 下发参数id name_id
    var str_name_id = "";
    // 当前指令下出口的数值
    var ui_curr_h_p_cnt = 0;

    var arr_order_each = [];
    var arr_param_each = [];
    var arr_hub_name = [];

    // eslint-disable-next-line guard-for-in
    for (var key in obj_data) {
        var arr_each_hw_hub_p_cnt = obj_data[key].cnt;
        var arr_each_hw_hub_name = obj_data[key].name;

        if ("-1" !== str_s_p_id) {
            // 页面指定发送卡的某个端口 找硬件是否存在
            if (str_s_p_page === key) {
                // hub卡
                if ("-1" === str_h_id) {
                    // 所有hub卡端口
                    for (var idx_one = 0; idx_one < arr_each_hw_hub_p_cnt.length; idx_one++) {
                        if (!arr_each_hw_hub_p_cnt[idx_one] || !arr_each_hw_hub_name[idx_one]) {
                            // 当前端口卡存 主控:主控端口 表示没有卡
                            str_name_id = key;
                            arr_order_each.push(str_name_id);
                            arr_param_each.push(-1);
                            arr_hub_name.push("");
                            continue;
                        }
                        str_name_id = key + ":" + idx_one;
                        arr_order_each.push(str_name_id);
                        ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[idx_one]);
                        arr_param_each.push(ui_curr_h_p_cnt);
                        arr_hub_name.push(arr_each_hw_hub_name[idx_one]);
                    }
                } else {
                    // 指定某长卡
                    if (!arr_each_hw_hub_p_cnt[ui_page_h]) {
                        continue;
                    }

                    str_name_id = key + ":" + ui_page_h;
                    arr_order_each.push(str_name_id);
                    ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[ui_page_h]);
                    arr_param_each.push(ui_curr_h_p_cnt);
                    arr_hub_name.push(arr_each_hw_hub_name[ui_page_h]);
                }
            }
        } else {
            // 所有发送卡端口
            // hub卡
            if ("-1" === str_h_id) {
                // 先判断是否所有卡数量和

                // 所有卡
                // 所有hub卡端口
                for (var idx_nd = 0; idx_nd < arr_each_hw_hub_p_cnt.length; idx_nd++) {
                    if (!arr_each_hw_hub_p_cnt[idx_nd] || !arr_each_hw_hub_name[idx_nd]) {
                        // 当前端口卡存 主控:主控端口 表示没有卡
                        str_name_id = key;
                        arr_order_each.push(str_name_id);
                        arr_param_each.push(-1);
                        arr_hub_name.push("");
                        continue;
                    }
                    str_name_id = key + ":" + idx_nd;
                    arr_order_each.push(str_name_id);
                    ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[idx_nd]);
                    arr_param_each.push(ui_curr_h_p_cnt);
                    arr_hub_name.push(arr_each_hw_hub_name[idx_nd]);
                }
            } else {
                // 指定某张hub卡端口
                if (arr_each_hw_hub_p_cnt.length <= ui_page_h) {
                    continue;
                }
                str_name_id = key + ":" + ui_page_h;
                arr_order_each.push(str_name_id);
                ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[ui_page_h]);
                arr_param_each.push(ui_curr_h_p_cnt);
                arr_hub_name.push(arr_each_hw_hub_name[ui_page_h]);
            }
        }
    }
    return [arr_order_each, arr_param_each, arr_hub_name];
}


// 进一步筛选 判断是否可发-1
function mc_backup_port_filter_data(arr_order, str_type, arr_result, arr_backup_status) {
    var ui_cnt = arr_result[0].length;

    // 循环所有 筛选备份或非备份状态 得出需要关闭的所有分控
    for (var idx = 0; idx < ui_cnt; idx++) {
        // 获取当前所有数据的端口
        var str_p_idx = arr_result[0][idx];

        str_p_idx = str_p_idx.split(":")[1];

        // 获取当前端口所对应端口的备份状态
        var str_backup_corresponing_status = arr_backup_status[Number(str_p_idx)];

        // 判断当前设置的发送
        if (parent.G_B_BACKUP_PORT_SEND) {
            // 发送备份口 关闭其他主口
            if ("0" !== str_backup_corresponing_status) {
                arr_result[1][idx] = mc_handle_port_stop_par(arr_result[1][idx], false);
            }
        } else {
            // 发送主口 关闭备份主口
            if ("1" !== str_backup_corresponing_status) {
                arr_result[1][idx] = mc_handle_port_stop_par(arr_result[1][idx], false);
            }
        }
    }

    // 进一步筛选 若同一个端口下的分控取值未-1  !!!!!暂时这样处理 端口下所有分控开关或关闭
    var arr_finall = [[], [], []];
    var str_prev_s_p = "";
    var arr_handle_order = "";
    var str_hangle_order = "";

    for (var id_fillter_hub = 0; id_fillter_hub < arr_result[0].length; id_fillter_hub++) {
        var str_curr_order = arr_result[0][id_fillter_hub];
        var str_curr_backup_val = arr_result[1][id_fillter_hub];
        // var str_curr_chip = arr_result[2][id_fillter_hub];
        var str_curr_s_p = arr_result[0][id_fillter_hub].split(":")[1];

        // 检测是数值
        if ("[object Number]" === Object.prototype.toString.call(str_curr_backup_val)) {
            arr_finall[0].push(str_curr_order);
            arr_finall[1].push(str_curr_backup_val);
            // arr_finall[2].push(str_curr_chip);
            continue;
        }

        if (0 === id_fillter_hub) {
            arr_handle_order = str_curr_order.split(":");
            str_hangle_order = arr_handle_order[0] + ":" + str_curr_s_p + ":" + "-1";

            arr_finall[0].push(str_hangle_order);
            arr_finall[1].push(str_curr_backup_val);
            // arr_finall[2].push(str_curr_chip);
            str_prev_s_p = str_curr_s_p;
            continue;
        }


        if (str_prev_s_p === str_curr_s_p) {
            continue;
        }
        str_prev_s_p = str_curr_s_p;
        arr_handle_order = str_curr_order.split(":");
        str_hangle_order = arr_handle_order[0] + ":" + str_curr_s_p + ":" + "-1";
        arr_finall[0].push(str_hangle_order);
        arr_finall[1].push(str_curr_backup_val);
        // arr_finall[2].push(str_curr_chip);
    }


    var arr_send_order = arr_finall[0];
    var arr_send_param = arr_finall[1];

    // 判断当前是否存在数据可下发
    var b_send_ok = false;

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("HW_HUBCARD_OUTPORT_ENABLE");

    for (var id_order = 0; id_order < arr_send_order.length; id_order++) {
        if (!arr_send_order[id_order] || !arr_send_param[id_order]) {
            continue;
        }
        if ("[OBJECT NUMBER]" === Object.prototype.toString.call(arr_send_param[id_order]).toLocaleUpperCase()) {
            continue;
        }
        // 当前是需要开启的话就不用发
        if (-1 !== arr_send_param[id_order].indexOf("1")) {
            continue;
        }
        b_send_ok = true;
        obj_req.set_param_value(arr_send_order[id_order], arr_send_param[id_order]);
        // obj_req.set_attr_val(arr_send_order[id_order], "CHIPNAME", arr_hub_name[id_order]);
        obj_req.set_attr_val(arr_send_order[id_order], "MEMTYPE", str_type);
    }

    if (b_send_ok) {
        return [obj_req.get_json(), arr_finall];
    }

    return [false, ""];
}

// 处理接口val值的格式
function mc_handle_port_stop_par(ui, b_stop) {
    // 是否开启禁用使能
    var str_mark_backup = b_stop ? "1" : "0";
    var str_val = "(";

    if (-1 === ui) {
        ui = 8;
    }

    for (var id = 0; id < ui; id++) {
        str_val += str_mark_backup;
        str_val += ":";
    }
    str_val = str_val.slice(0, -1);
    str_val += ")";
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    开启已关闭的状态
 * 参数:
 *    @param {Promise<Array>} arr_data     下发的数据
 *    @param {Promise<string>} type     memory
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    @return {Promise<boolean>} false/true

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_open_all_backup_stauts(arr_data, type, fun_callback) {
    if (!arr_data) {
        fun_callback();
        return false;
    }
    var arr_order = arr_data[0];
    var arr_val = arr_data[1];
    var ui_cnt = arr_order.length;

    if (0 === ui_cnt) {
        fun_callback();
        return false;
    }

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("HW_HUBCARD_OUTPORT_ENABLE");
    var b_true = false;

    for (var idx = 0; idx < ui_cnt; idx++) {
        var str_par_name = arr_order[idx];
        var str_val = arr_val[idx];

        if ("[object Number]" === Object.prototype.toString.call(str_val)) {
            continue;
        }

        var ui_port_cnt = str_val.slice(1, -1).split(":").length;

        var str_send_val = "(";

        for (var id = 0; id < ui_port_cnt; id++) {
            str_send_val += "1:";
        }

        str_send_val = str_send_val.slice(0, -1);
        str_send_val += ")";

        b_true = true;

        obj_req.set_param_value(str_par_name, str_send_val);
        obj_req.set_attr_val(str_par_name, "MEMTYPE", type);
    }

    if (b_true) {
        $.post("/access_shell", obj_req.get_json(), function (result, status) {
            fun_callback();
            return true;
        });
    }

    return false;
}
